/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/
#include "DX_VOS_Utils.h"
#include "tOEMIMP.h"
#include "DX_VOS_String.h"
#include "drmcrt.h"
#if 0
#include "oemcriticalsection.c"
#include "oemfileio.c"
#include "oemimpl.c"
#include "oeminfo.c"
#include "oemtime.c"
#endif
static void  OEM_StrToInt(const DxChar *aString, DxUint32_t stringSize, DxInt32_t* value, DxUint_t base);

DRM_INT  OEM_atoi(const char * str )
{
	DRM_INT val=0;
	if(str == NULL)
		return 0;
	
	OEM_StrToInt(str,DX_VOS_StrLen(str),&val,10);

	return val;
}

DRM_LONG OEM_atol(const char * str )
{
	DRM_LONG val=0;
	if(str == NULL)
		return 0;
	
	OEM_StrToInt(str,DX_VOS_StrLen(str),&val,10);
	return val;
}

DRM_INT OEM_rand(void)
{
	DRM_INT	rVal;

	OEM_GenRandomBytes((DRM_BYTE*)&rVal,sizeof(rVal));
	return rVal;
}


DRM_BOOL OEM_isdigit(DRM_BYTE ch)
{

	if( (ch >= '0') && (ch <= '9'))
		return TRUE;

	return FALSE;
}

DRM_BOOL OEM_isspace(DRM_BYTE ch)
{

	if( (ch == 0x20) /* space */||
		(ch == 0x9) /* tab */ ||
		(ch == 0xB) /* vertical tab */ ||
		(ch == 0xC) /* form feed */ ||
		(ch == 0xD) /* carriage return */ ||
		(ch == 0xA) /* newline */)
		return TRUE;

	return FALSE;
}


DRM_UINT OEM_mbstowcs(DRM_WCHAR *destination,const char *source,int  length)
{
	DRM_UINT strLen;

	/*nothing to convert return 0*/
	if(source == NULL)
	{
		return 0;
	}
	/*get string length */
	strLen = DX_VOS_StrLen(source);
	/*No dest buffer just return the required memory */
	if(destination == NULL)
	{
		/*Add one for the '\0'*/
		return (strLen);
	}
	/*convert the string to wide-char string */
	DX_VOS_Utf8ToWChar(destination, (length+1)*sizeof(DRM_WCHAR),source);
	
	/*return the length of the wide string*/
	return DRM_wcslen(destination);


}


int OEM_wcstombs (char *destination,const DRM_WCHAR *source,int  length)
{

	DRM_WCHAR buffer[2] = {0};
	int returnval=0;

	if(source == NULL)
		return (-1);

	/*We have to do the conversion only if destination is not NULL, else we just get the memory required*/
	if(destination !=NULL)
	{
		while(*source !=(char)NULL && length > 0)
		{
			buffer[0] = *source;
			*destination = buffer[0] &0xFF;
				
			destination++;
			source++;
			length--;
			returnval++;
		}
		*destination = (char)NULL; /*terminate the string with a NULL*/
	}
	else
	{
		while(*source !=(char)NULL && length > 0)
		{
			source++;
			returnval++;
			length--;
		}
	}
	
	
	return (returnval);
}


DRM_WCHAR *OEM_wcsstr(const DRM_WCHAR *str, const DRM_WCHAR *strSearch )
{
	if (strSearch == NULL || str == NULL)
		return NULL;
	while (*str != 0)
	{
		const DRM_WCHAR* str1 = str;
		const DRM_WCHAR* str2 = strSearch;
		while (*str1 == *str2 && *str1 != 0)
		{
			str1++;
			str2++;
		}
		if (*str2 == 0)
			return (DRM_WCHAR*)str;
		if (*str1 == 0)
			break;
		str++;
	}
	return NULL;
}

void OEM_wcscat(DRM_WCHAR *wszDestination, const DRM_WCHAR *wszSource)
{
	DRM_DWORD sourcelen = 0;
	int i = 0;
	if(wszSource !=NULL && wszDestination !=NULL)
	{
	    sourcelen = DRM_wcslen(wszSource);

	    while(*wszDestination != g_wchNull)
		wszDestination++;
	    DRM_wcsncpy(wszDestination,wszSource,sourcelen);
	}
}


DRM_WCHAR *OEM_wcscpy(DRM_WCHAR *dest, const DRM_WCHAR *src)
{
    DRM_WCHAR *p;

    /* validation section */
	if((dest == NULL) || (src == NULL))
	{
		return NULL;
	}
    p = dest;
    while (*src != 0 )
    {
		*p++ = *src++;
	}

	return dest;
}
static void  OEM_StrToInt(const DxChar *aString, DxUint32_t stringSize, DxInt32_t* value, DxUint_t base)
{
	DxInt_t sign = 1;
    const DxChar* stringStart = aString;

    if(aString == NULL)
	{
		return;
	}
    if(value == NULL)
	{
		return;
	}

	if (base == 1 || base > 16)
		return;

	*value = 0;
	aString = DX_VOS_SkipWhiteSpaces(aString, " \t");
	if (*aString == '-')
	{
		sign = -1;
		aString++;
	}
	else if (*aString == '+')
	{
		sign = 1;
		aString++;
	}
	if (base == 0)
	{
		if (*aString == 'b')
		{
			base = 2;
			aString++;
		}
		else if (*aString == '0')
		{
			base = 8;
			aString++;
			if (*aString == 'x')
			{
				base = 16;
				aString++;
			}
		} else
			base = 10;
	}
	while (*aString != 0 && (DxUint32_t)(aString  - stringStart) < stringSize)
	{
		DxUint_t digitVal = 100;
		DxInt32_t oldValue = *value;
		if (*aString >= '0' && *aString <= '9') digitVal = *aString - '0';
		if (*aString >= 'a' && *aString <= 'f') digitVal = 10 + *aString - 'a';
		if (*aString >= 'A' && *aString <= 'F') digitVal = 10 + *aString - 'A';
		if (digitVal > base)
			break;
		*value = *value * base + digitVal;
		if (*value < oldValue)
			break;
		++aString;
	}

	*value *= sign;
	return;
}

